clear

figure('Position', [500 300 500 300])

t = tiledlayout(1,1);
t.TileSpacing = 'none';
t.Padding = 'none';

phi = 0:20;

a = 41.6625;
l = 166.65;
B = 75.75;
theta = -180:0.01:180;

IntakePistonPosition = zeros(1, length(theta));
ExhaustPistonPosition = zeros(1, length(theta));
CylinderVolume = zeros(1, length(theta));

ClearanceVolume = zeros(length(phi),1);
GeometricCompressionRatio = zeros(length(phi),1);


for k = 1:length(phi)
    
    for x = 1:length(theta)
        IntakePistonPosition(x) = (a - l + a*cos((theta(x)-(phi(k)/2))*pi/180) + sqrt(l^2 - a^2*sin((theta(x)-(phi(k)/2))*pi/180).^2))/(2*a);
        ExhaustPistonPosition(x) = (a - l + a*cos((theta(x)+(phi(k)/2))*pi/180) + sqrt(l^2 - a^2*sin((theta(x)+(phi(k)/2))*pi/180).^2))/(2*a);
        CylinderVolume(x) = ((2*a * (2 - IntakePistonPosition(x) - ExhaustPistonPosition(x))) + 11.6551) * pi()/4 * B^2;
    end
    
    ClearanceVolume(k) = min(CylinderVolume);
    GeometricCompressionRatio(k) = max(CylinderVolume) / min(CylinderVolume);
    
end

plot(phi,GeometricCompressionRatio)
ytickformat('%.1f')
xlabel('Crankshaft Phase Angle [deg]')
ylabel('Geometric Compression Ratio')
set(gca, 'FontSize', 12)
